/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.compliance;

import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.TitledBorder;

public class EDIDDeclareFolder
extends QDPanel
implements ActionListener {
    private QDCheckBox[] m_checkBoxes;
    private QDPanel innerPanel;
    private QDPanel innerPanel2;
    private QDButton[] button;
    private JComboBox[] comboBox;
    RemoteInstrument m_instrument;
    String tempStr = "";
    String fileStr = "Unknown";
    private static final Font m_checkBoxFont = new Font("SansSerif", 1, 12);
    private static final int cts13Offset = 16;
    private static final int fmtOffset = 26;
    private static final int cts13FmtOffset = 39;

    public EDIDDeclareFolder() {
        this.init();
    }

    private void init() {
        int n;
        this.setBackground(Color.white);
        this.m_checkBoxes = new QDCheckBox[41];
        this.button = new QDButton[3];
        this.comboBox = new JComboBox[3];
        this.m_checkBoxes[0] = new QDCheckBox("CEC Root Device");
        this.m_checkBoxes[0].putClientProperty("Command", "CECR");
        this.m_checkBoxes[1] = new QDCheckBox("HDTV");
        this.m_checkBoxes[1].putClientProperty("Command", "HDTV");
        this.m_checkBoxes[2] = new QDCheckBox("YUV On Other");
        this.m_checkBoxes[2].putClientProperty("Command", "YUVO");
        this.m_checkBoxes[3] = new QDCheckBox("60Hz");
        this.m_checkBoxes[3].putClientProperty("Command", "HZ60");
        this.m_checkBoxes[4] = new QDCheckBox("50Hz");
        this.m_checkBoxes[4].putClientProperty("Command", "HZ50");
        this.m_checkBoxes[5] = new QDCheckBox("720p/60Hz On Other");
        this.m_checkBoxes[5].putClientProperty("Command", "FMO1");
        this.m_checkBoxes[6] = new QDCheckBox("1080i/60Hz On Other");
        this.m_checkBoxes[6].putClientProperty("Command", "FMO2");
        this.m_checkBoxes[7] = new QDCheckBox("480p/60Hz On Other");
        this.m_checkBoxes[7].putClientProperty("Command", "FMO3");
        this.m_checkBoxes[8] = new QDCheckBox("720p/50Hz On Other");
        this.m_checkBoxes[8].putClientProperty("Command", "FMO4");
        this.m_checkBoxes[9] = new QDCheckBox("1080i/50Hz On Other");
        this.m_checkBoxes[9].putClientProperty("Command", "FMO5");
        this.m_checkBoxes[10] = new QDCheckBox("576p/50Hz On Other");
        this.m_checkBoxes[10].putClientProperty("Command", "FMO6");
        this.m_checkBoxes[11] = new QDCheckBox("Supports AI");
        this.m_checkBoxes[11].putClientProperty("Command", "AIOK");
        this.m_checkBoxes[12] = new QDCheckBox("Basic Audio");
        this.m_checkBoxes[12].putClientProperty("Command", "BAUD");
        this.m_checkBoxes[13] = new QDCheckBox("Connector Type A");
        this.m_checkBoxes[13].putClientProperty("Command", "CONA");
        this.m_checkBoxes[14] = new QDCheckBox("Write Protect Test");
        this.m_checkBoxes[14].putClientProperty("Command", "WPRT");
        this.m_checkBoxes[15] = new QDCheckBox("HDMI 1.3B Testing");
        this.m_checkBoxes[15].putClientProperty("Command", "CTS3");
        this.m_checkBoxes[15].addActionListener(this);
        this.m_checkBoxes[16] = new QDCheckBox("Deep Color");
        this.m_checkBoxes[16].putClientProperty("Command", "DCOK");
        this.m_checkBoxes[17] = new QDCheckBox("30-bit Deep Color");
        this.m_checkBoxes[17].putClientProperty("Command", "DC30");
        this.m_checkBoxes[18] = new QDCheckBox("36-bit Deep Color");
        this.m_checkBoxes[18].putClientProperty("Command", "DC36");
        this.m_checkBoxes[19] = new QDCheckBox("48-bit Deep Color");
        this.m_checkBoxes[19].putClientProperty("Command", "DC48");
        this.m_checkBoxes[20] = new QDCheckBox("YCbCr Deep Color");
        this.m_checkBoxes[20].putClientProperty("Command", "DCY4");
        this.m_checkBoxes[21] = new QDCheckBox("xvYCC");
        this.m_checkBoxes[21].putClientProperty("Command", "XVYC");
        this.m_checkBoxes[22] = new QDCheckBox("Exceeds 165MHz");
        this.m_checkBoxes[22].putClientProperty("Command", "E165");
        this.m_checkBoxes[23] = new QDCheckBox("Dual-link DVI");
        this.m_checkBoxes[23].putClientProperty("Command", "DLDV");
        this.m_checkBoxes[24] = new QDCheckBox("Lipsync");
        this.m_checkBoxes[24].putClientProperty("Command", "LIPS");
        this.m_checkBoxes[25] = new QDCheckBox("Dual Lipsync Latencies");
        this.m_checkBoxes[25].putClientProperty("Command", "LATS");
        this.m_checkBoxes[26] = new QDCheckBox("640x480p/60Hz 4:3");
        this.m_checkBoxes[26].putClientProperty("Command", "FMT7");
        this.m_checkBoxes[26].setSelected(true);
        this.m_checkBoxes[27] = new QDCheckBox("720x576p/50Hz 4:3");
        this.m_checkBoxes[27].putClientProperty("Command", "FMT6");
        this.m_checkBoxes[28] = new QDCheckBox("720x480p/60Hz 4:3");
        this.m_checkBoxes[28].putClientProperty("Command", "FMT3");
        this.m_checkBoxes[29] = new QDCheckBox("720x576p/50Hz 16:9");
        this.m_checkBoxes[29].putClientProperty("Command", "FMT9");
        this.m_checkBoxes[30] = new QDCheckBox("720x480p/60Hz 16:9");
        this.m_checkBoxes[30].putClientProperty("Command", "FMT8");
        this.m_checkBoxes[31] = new QDCheckBox("1280x720p/50Hz 16:9");
        this.m_checkBoxes[31].putClientProperty("Command", "FMT4");
        this.m_checkBoxes[32] = new QDCheckBox("1280x720p/60Hz 16:9");
        this.m_checkBoxes[32].putClientProperty("Command", "FMT1");
        this.m_checkBoxes[33] = new QDCheckBox("1920x1080i/50Hz 16:9");
        this.m_checkBoxes[33].putClientProperty("Command", "FMT5");
        this.m_checkBoxes[34] = new QDCheckBox("1920x1080i/60Hz 16:9");
        this.m_checkBoxes[34].putClientProperty("Command", "FMT2");
        this.m_checkBoxes[35] = new QDCheckBox("1440x576i/50Hz 4:3");
        this.m_checkBoxes[35].putClientProperty("Command", "FM12");
        this.m_checkBoxes[36] = new QDCheckBox("1440x480i/60Hz 4:3");
        this.m_checkBoxes[36].putClientProperty("Command", "FM10");
        this.m_checkBoxes[37] = new QDCheckBox("1440x576i/50Hz 16:9");
        this.m_checkBoxes[37].putClientProperty("Command", "FM13");
        this.m_checkBoxes[38] = new QDCheckBox("1440x480i/60Hz 16:9");
        this.m_checkBoxes[38].putClientProperty("Command", "FM11");
        this.m_checkBoxes[39] = new QDCheckBox("1920x1080p/60Hz 16:9");
        this.m_checkBoxes[39].putClientProperty("Command", "FM14");
        this.m_checkBoxes[40] = new QDCheckBox("1920x1080p/50Hz 16:9");
        this.m_checkBoxes[40].putClientProperty("Command", "FM15");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.innerPanel = new QDPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        String string = "HDMI Output Count: ";
        this.comboBox[0] = new JComboBox();
        this.comboBox[0].putClientProperty("Command", "OCNT");
        for (n = 0; n < 10; ++n) {
            this.comboBox[0].addItem(string + n);
        }
        this.comboBox[0].setFont(m_checkBoxFont);
        this.innerPanel.add((Component)this.comboBox[0], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.comboBox[1] = new JComboBox();
        this.comboBox[1].putClientProperty("Command", "CIPN");
        string = "HDMI Input Port #: ";
        for (n = 1; n < 16; ++n) {
            this.comboBox[1].addItem(string + n);
        }
        this.comboBox[1].setFont(m_checkBoxFont);
        ++gridBagConstraints.gridy;
        this.innerPanel.add((Component)this.comboBox[1], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.m_checkBoxes[0].setFont(m_checkBoxFont);
        this.innerPanel.add((Component)this.m_checkBoxes[0], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.comboBox[2] = new JComboBox();
        this.comboBox[2].putClientProperty("Command", "PRAR");
        this.comboBox[2].addItem(new String("Primary Aspect Ratio: 4:3"));
        this.comboBox[2].addItem(new String("Primary Aspect Ratio: 16:9"));
        this.comboBox[2].setFont(m_checkBoxFont);
        this.innerPanel.add((Component)this.comboBox[2], gridBagConstraints);
        ++gridBagConstraints.gridy;
        for (n = 1; n < 26; ++n) {
            this.m_checkBoxes[n].setFont(m_checkBoxFont);
            this.innerPanel.add((Component)this.m_checkBoxes[n], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        QDPanel qDPanel = new QDPanel(gridBagLayout);
        TitledBorder titledBorder = new TitledBorder("Formats");
        titledBorder.setTitleColor(Color.WHITE);
        qDPanel.setBorder(titledBorder);
        for (int i = 26; i < this.m_checkBoxes.length; ++i) {
            this.m_checkBoxes[i].setFont(m_checkBoxFont);
            qDPanel.add((Component)this.m_checkBoxes[i], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 27;
        Dimension dimension = new Dimension(750, 800);
        this.innerPanel.setPreferredSize(dimension);
        this.innerPanel.add((Component)qDPanel, gridBagConstraints);
        this.innerPanel2 = new QDPanel();
        this.button[0] = new QDButton("Use CDF");
        this.button[0].addActionListener(this);
        this.innerPanel2.add(this.button[0]);
        this.button[1] = new QDButton("Auto-Generate CDF");
        this.button[1].addActionListener(this);
        this.innerPanel2.add(this.button[1]);
        this.button[2] = new QDButton("Run Test");
        this.button[2].addActionListener(this);
        this.innerPanel2.add(this.button[2]);
        JScrollPane jScrollPane = new JScrollPane(this.innerPanel, 22, 30);
        jScrollPane.setLayout(new ScrollPaneLayout());
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)jScrollPane, "North");
        this.add((Component)this.innerPanel2, "South");
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_instrument = remoteInstrument;
        this.GetCdfEntriesFromUnit();
    }

    private void GetCdfEntriesFromUnit() {
        InstrumentResponse instrumentResponse;
        int n;
        for (n = 0; n < this.comboBox.length; ++n) {
            this.tempStr = this.comboBox[n].getClientProperty("Command") + "?";
            try {
                instrumentResponse = this.m_instrument.sendCmd("ECTX:" + this.tempStr);
                if (instrumentResponse.isError()) continue;
                int n2 = Integer.parseInt(instrumentResponse.getResponse());
                if (n == 1) {
                    --n2;
                }
                this.comboBox[n].setSelectedIndex(n2);
                continue;
            }
            catch (Exception exception) {
                EDIDDeclareFolder.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
        for (n = 0; n < this.m_checkBoxes.length; ++n) {
            this.tempStr = this.m_checkBoxes[n].getClientProperty("Command") + "?";
            try {
                instrumentResponse = this.m_instrument.sendCmd("ECTX:" + this.tempStr);
                if (instrumentResponse.isError()) continue;
                if (instrumentResponse.getResponse().equalsIgnoreCase("1")) {
                    this.m_checkBoxes[n].setSelected(true);
                    continue;
                }
                this.m_checkBoxes[n].setSelected(false);
                continue;
            }
            catch (Exception exception) {
                EDIDDeclareFolder.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
        this.set13CtsOptionsEnabled(this.m_checkBoxes[15].isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block15: {
            block16: {
                block14: {
                    int n;
                    if (!this.m_instrument.isConnected()) {
                        return;
                    }
                    if (actionEvent.getSource() == this.m_checkBoxes[15]) {
                        this.set13CtsOptionsEnabled(this.m_checkBoxes[15].isSelected());
                    }
                    if (actionEvent.getSource() != this.button[0]) break block14;
                    for (n = 0; n < this.comboBox.length; ++n) {
                        this.tempStr = this.comboBox[n].getClientProperty("Command") + " ";
                        int n2 = this.comboBox[n].getSelectedIndex();
                        if (n == 1) {
                            ++n2;
                        }
                        this.tempStr = this.tempStr + n2;
                        try {
                            this.errorCheck(this.m_instrument.sendCmd("ECTX:" + this.tempStr));
                            Thread.sleep(2L);
                            continue;
                        }
                        catch (Exception exception) {
                            EDIDDeclareFolder.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
                        }
                    }
                    for (n = 0; n < this.m_checkBoxes.length; ++n) {
                        this.tempStr = this.m_checkBoxes[n].getClientProperty("Command") + " ";
                        this.tempStr = this.m_checkBoxes[n].isSelected() ? this.tempStr + "1" : this.tempStr + "0";
                        try {
                            this.errorCheck(this.m_instrument.sendCmd("ECTX:" + this.tempStr));
                            Thread.sleep(2L);
                            continue;
                        }
                        catch (Exception exception) {
                            EDIDDeclareFolder.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
                        }
                    }
                    break block15;
                }
                if (actionEvent.getSource() != this.button[1]) break block16;
                try {
                    this.errorCheck(this.m_instrument.sendCmd("EDA1:GDID"));
                    this.errorCheck(this.m_instrument.sendCmd("ECTX:AUTO"));
                }
                catch (Exception exception) {
                    EDIDDeclareFolder.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
                }
                this.GetCdfEntriesFromUnit();
                break block15;
            }
            if (actionEvent.getSource() != this.button[2]) break block15;
            try {
                this.errorCheck(this.m_instrument.sendCmd("EDA1:GDID"));
                InstrumentResponse instrumentResponse = this.m_instrument.sendCmd("ECTX:ECTU");
                if (instrumentResponse.isError()) {
                    JOptionPane.showMessageDialog(this, instrumentResponse.getResponse(), "ERROR!", 0);
                }
                JOptionPane.showMessageDialog(this, "Testing complete.  Please go to the Reports tab for results.", "Test complete", 1);
            }
            catch (Exception exception) {
                EDIDDeclareFolder.ShowErrorMessage(this, "Exception " + exception.getMessage() + " occurred.", "ERROR!");
            }
        }
    }

    public void errorCheck(InstrumentResponse instrumentResponse) {
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(this, instrumentResponse.getResponse(), "ERROR!", 0);
        }
    }

    private void set13CtsOptionsEnabled(boolean bl) {
        int n;
        for (n = 16; n < 26; ++n) {
            this.m_checkBoxes[n].setEnabled(bl);
        }
        for (n = 39; n < this.m_checkBoxes.length; ++n) {
            this.m_checkBoxes[n].setEnabled(bl);
        }
    }

    public void printGeneratorError(int n) {
        String string = "Unknown error " + n + " occurred.  May not affect testing.";
        if (n == 1) {
            string = "Error!  Message sent to test equipment was not recognized!  (Error 1)";
        }
        if (n == 4) {
            string = "Error!  Message sent to test equipment had an invalid number of arguments! (Error 4)";
        }
        if (n == 6) {
            string = "Error!  File could not be used.  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 6)";
        }
        if (n == 99) {
            string = "Internal error!  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 99)";
        }
        if (n == 10031) {
            string = "Error!  Feature not enabled.  Please contact Quantum Data for licensing details. (Error 10031)";
        }
        EDIDDeclareFolder.ShowErrorMessage(this, string, "ERROR!");
    }

    public static void ShowErrorMessage(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string, string2, 0);
    }
}

